
% 
% Demo Basic Robot Motion 
%
% Launch the virtual machine.
% Open terminal, and start the empty Gazebo world: ./start-gazebo-empty.sh.
%
% Versions: 
% v01 - UC Summer School 2023 

% clear memory 
clearvars -except tbot

% -----------------------------------------------------------------------------
% start TurtleBot connection (tbot object), only if required
if ( ~exist("tbot") ) 
    % init by assign the IPs directly by the TurtleBot constructor
    IP_TURTLEBOT = "192.168.1.110";         % virtual machine IP (or robot IP)
    IP_HOST_COMPUTER = "192.168.1.100";     % local machine IP
    tbot = TurtleBot3(IP_TURTLEBOT, IP_HOST_COMPUTER);
end 
% -----------------------------------------------------------------------------


% Reset Turtlebot's 2D pose, place robot at (x,y,theta) -> (0,0,0) 
tbot.resetPose();
pause(1);           % wait 1s 


% move robot forward 
tbot.move(0.1, 0);  % v = 0.1 m/s, w = 0 rad/s 
fprintf('move forward\n'); 
pause(5);           % wait 5s 

% rotate robot anti-clockwise 
tbot.move(0, 0.5);  % v = 0 m/s, w = 0.5 rad/s 
fprintf('rotate\n'); 
pause(3);           % wait 3s 

% move robot backward 
tbot.move(-0.1, 0); 
fprintf('move backward\n'); 
pause(3);           % wait 3s 


% stop robot 
tbot.stop();  
fprintf('stop\n'); 

