
% 
% Demo - Add Objects w/ uTurtleBot3 (Micro TurtleBot3) interface
% 
%
% Open MatLab and run the script >> udemoPlaceObjects.m
%

% clear memory 
clear;

%---------------------------------------------------------
% init uTurtleBot3 interface (no IP configuration required)
%---------------------------------------------------------
% init uTurtleBot3 interface w/ internal sampling time (dt) 
dt = 0.2;                 %  frequency = 1/dt = 5Hz
tbot = uTurtleBot3( dt ); 

% check version
if( tbot.getVersion() < 2.1 ) error('uTurtleBot3 v2a required'); end 

%---------------------------------------------------------
% Place 3D Objects 
%---------------------------------------------------------
% -> The uTurtleBot3 interface rasterizes all 3D objects into a 2D virtual map 

% uPlace3DCardboardBox(x, y, orientation);
tbot.uPlace3DCardboardBox(0.5, 0.5, 0);
tbot.uPlace3DCardboardBox(0.5, 1.5, pi/4);
tbot.uPlace3DCardboardBox(0.5, 2.5, pi/2); 

% uPlace3DCube(x, y, orientation, edgeSize, color);
tbot.uPlace3DCube(2, 0.5, 0, 0.25);
tbot.uPlace3DCube(2, 1.5, 0, 0.5);
tbot.uPlace3DCube(2, 2.5, pi/4, 1);

% uPlace3DCylinder(x, y, radius);
tbot.uPlace3DCylinder(3.5, 0.5, 0.1);
tbot.uPlace3DCylinder(3.5, 1.5, 0.25);
tbot.uPlace3DCylinder(3.5, 2.5, 0.5);


%---------------------------------------------------------
% Get Virtual 2D Map (rasterized objects)
%---------------------------------------------------------

% Get the 2D virtual map of rasterized objects (and scale factor) 
[vmap, mscale] = tbot.getVirtualMap();

% get map size (rows, cols) 
[hm, wm] = size(vmap);

% find (rowm, colm) coordinates of obstacles
[rowm, colm] = find( vmap == 1);




% Place TurtleBot at (x, y, theta)
x = 0; y = 0; theta = 0; 
tbot.setPose(x, y, theta);



% ------------------ 
% Display   
% ------------------   
figure(1); clf; hold on;
%set(gcf,'Position',[170,700,800,600])  % modify the figure position and size
plot( rowm./mscale, colm./mscale,'k.')  % plot obstacles 
drawTurtleBot(x, y, theta);         % draw Robot

quiver(0,0,1,0,0.5,'r')             % draw arrow for x-axis 
quiver(0,0,0,1,0.5,'g')             % draw arrow for y-axis 
axis([-0.1, hm/mscale, -0.1, wm/mscale]) % set limits for the current axes
grid on;                            % enable grid 
xlabel('x')                         % axis labels 
ylabel('y')




