
% 
% Demo - Read 2D pose from TurtleBot3 mobile robot 
% (using the Micro TurtleBot3 - uTurtleBot3 - basic interface).
%
% Open MatLab and run the script >> udemoPose.m
%

% clear memory 
clear;

%---------------------------------------------------------
% init uTurtleBot3 interface (no IP configuration required)
%---------------------------------------------------------
% init uTurtleBot3 interface w/ internal sampling time (dt) 
dt = 0.2;                 %  frequency = 1/dt = 5Hz
tbot = uTurtleBot3( dt ); 

% check version
if( tbot.getVersion() < 2.1 ) error('uTurtleBot3 v2a required'); end 


% reset TurtleBot's 2D pose (x, y, theta) -> (0,0,0) 
tbot.resetPose();
% alternatively, place robot at diferent pose (x, y, theta)
%tbot.setPose( 1, 2, -pi/2);


%---------------------------------------------------------
% Execute loop at fixed frequency
%---------------------------------------------------------

% init ratecontrol obj (enables to run a loop at a fixed frequency) 
r = rateControl( 1 / dt );     % run at 5Hz

% send linear + angular velocity command
tbot.setVelocity(0.075, 0.05);

% run for 10 seconds: 50 iterations (50 x 1/5 = 10s) 
for it = 1:1:50 

    % read TurtleBot pose (and timestamp) 
    [x, y, theta, timestamp] = tbot.readPose();

    % display
    figure(1); clf; hold on;            % clear figure, hold plots
    drawTurtleBot(x, y, theta);         % draw Robot    
    % draw x-y axis
    quiver(0,0,1,0,'r')                 % draw arrow for x-axis 
    quiver(0,0,0,1,'g')                 % draw arrow for y-axis 
    axis([-3, 3, -3, 3])                % the limits for the current axes [xmin xmax ymin ymax]
    grid on;                            % enable grid 
    xlabel('x')                         % axis labels 
    ylabel('y')
    title('demo Pose')                  % add title 
  
    % adaptive pause
    waitfor(r);

end

% check statistics of past execution periods
stats = statistics(r);

% stop robot 
tbot.stop();
 
